<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_menu', 'pro_slider_wp_add_admin_menu' );

function pro_slider_wp_add_admin_menu() {
    add_menu_page( 'ProSlider WP Ayarları', 'ProSlider WP', 'manage_options', 'pro_slider_wp', 'pro_slider_wp_settings_page_render', 'dashicons-images-alt2', 26 );
}

function pro_slider_wp_settings_page_render() {
    $active_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : 'content';
    ?>
    <div class="wrap">
        <h1>ProSlider WP Ayarları</h1>
        <h2 class="nav-tab-wrapper">
            <a href="?page=pro_slider_wp&tab=content" class="nav-tab <?php echo $active_tab == 'content' ? 'nav-tab-active' : ''; ?>">İçerik Ayarları</a>
            <a href="?page=pro_slider_wp&tab=design" class="nav-tab <?php echo $active_tab == 'design' ? 'nav-tab-active' : ''; ?>">Tasarım & Boyut</a>
            <a href="?page=pro_slider_wp&tab=nav" class="nav-tab <?php echo $active_tab == 'nav' ? 'nav-tab-active' : ''; ?>">Navigasyon & Efektler</a>
        </h2>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'pro_slider_settings_group' );

            if( $active_tab == 'content' ) {
                do_settings_sections( 'pro_slider_content_page' );
            } elseif( $active_tab == 'design' ) {
                do_settings_sections( 'pro_slider_design_page' );
            } else {
                do_settings_sections( 'pro_slider_nav_page' );
            }
            submit_button( 'Değişiklikleri Kaydet' );
            ?>
        </form>

        <script type="text/javascript">
            jQuery(document).ready(function($) {
                $('.pro-slider-select2').select2({
                    placeholder: "Bir veya daha fazla kategori seçin",
                    allowClear: true
                });
            });
        </script>
    </div>
    <?php
}